import search
import inspect

DEBUG = False

def debug():
    if DEBUG:
        info = inspect.stack()[1]
        name = info[3]
        f = vars(search)[name]
        signature = inspect.signature(f)
        local = info[0].f_locals
        param = []
        for formal in signature.parameters:
            actual = local[formal]
            if isinstance(actual,list):
                param.append(formal)
            else:
                param.append(str(actual))
        print("%s(%s)" % (name, ', '.join(param)))

def activateDebug():
    global DEBUG
    DEBUG = True
